package it.unicam.pizzeria4.view;

import it.unicam.pizzeria4.sala.Sala;
import it.unicam.pizzeria4.util.*;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;

public class IAddettoSala {
	private Sala sala;


	public IAddettoSala() {
		this.sala = Sala.getInstance();
	}
		
	public void assegnaTavolo(Scanner reader) {
		ArrayList<DettagliTavolo> vdt;
		vdt = sala.assegnazioneTavolo();
		Iterator<DettagliTavolo> vdti = vdt.iterator();
		System.out.println("\n[INFO] STATO DEI TAVOLI DELLA SALA ('+' libero/'-' occupato, ID, Capienza, Immagine mostrata)");
		while (vdti.hasNext()) {
			System.out.println(vdti.next());
		}
		System.out.println("[REQS]: Quanti sono gli ospiti?");
		String ospiti = reader.nextLine();
		int nOspiti = Integer.parseInt(ospiti);
		String tavoloID;
		if (getTavolo(nOspiti)) {
			System.out.print("[REQS] Seleziona uno dei tavoli proposti:  ");
			tavoloID = reader.nextLine();
			riservaTavolo(tavoloID, nOspiti);
			System.out.println();
		} else {
			System.out.println("[REQS] Vuoi creare un tavolo componendo quelli disponibili? (S/N)");
			String risposta = reader.nextLine();
			if (risposta.equals("S")) {
				System.out.println("[INFO] Separa gli identificativi con uno spazio");
				tavoloID = reader.nextLine();
				String[] tavoliID = tavoloID.split("\\s+");
				riservaTavolo(tavoliID, nOspiti);
				System.out.println();
			} else {
				System.out.println("[INFO] Ci spiace non poter soddisfare la richiesta.");
			}
		}

	}

	
//	public void assegnaTavolo() {
//		ArrayList<DettagliTavolo> vdt;
//		vdt = sala.assegnazioneTavolo();
//		Iterator<DettagliTavolo> vdti = vdt.iterator();
//		System.out.println("\n[INFO] STATO DEI TAVOLI DELLA SALA ('+' libero/'-' occupato, ID, Capienza, Immagine mostrata)");
//		while (vdti.hasNext()) {
//			System.out.println(vdti.next());
//		}
//	}

	/**
	 * 
	 * @param numCoperti
	 */
	public boolean getTavolo(int numCoperti) {
		ArrayList<String> tavoliLiberi = sala.getTavolo(numCoperti);
		if (!tavoliLiberi.isEmpty()) {
			Iterator<String> vtl = tavoliLiberi.iterator();
			while (vtl.hasNext()) {
				System.out.print(vtl.next());
				if (vtl.hasNext()) {
					System.out.print(" - ");
				} else {
					System.out.print("\n");
				}
			}
			return true;
		} else {
			System.out.println("Non ci sono tavoli disponibili per soddisfare la richiesta.");
			return false;
		}
	}

	/**
	 * 
	 * @param idTavolo
	 */
	public void riservaTavolo(String idTavolo, int numCoperti) {
		sala.riservaTavolo(idTavolo, numCoperti);
	}

	/**
	 * 
	 * @param idTavolo
	 */
	public void riservaTavolo(String[] idTavolo, int numCoperti) {
			sala.riservaTavolo(idTavolo, numCoperti);
	}

	/**
	 * 
	 * @param idTavolo
	 */
	public void liberaTavolo(Scanner reader) {
		String idTavolo=reader.nextLine();
    	sala.liberaTavolo(idTavolo);
    }

}
